----------------
title : C++ 레퍼런스 - basic_string_view
cat_title :  basic_string_view
ref_title : basic_string_view, std::basic_string_view
path : /C++ Reference/string_view
----------------

##@ cpp-ref-start

#@ basic_string_view

`<string_view>` 에 정의됨.

```cpp-formatted
template <class CharT, class Traits = std::char_traits<CharT> >
class basic_string_view;
```

클래스 템플릿 `basic_string_view` 는 연속된 문자의 나열의 시작점을 가리키는 객체를 만들어줍니다.

```cpp-formatted
const char *s = "abc";
```

쉽게 생각해서, 위의 `s` 의 역할을 수행하는 객체라 생각하시면 됩니다. 

그렇다면, 그냥 포인터를 쓰면 될것이지 도대체 왜 굳이 `basic_string_view` 를 사용하냐면, 일반적인 `const char*` 과 같은 포인터와는 달리, `basic_string_view` 는 가리키는 대상의 **길이** 도 기억하고 있기 때문에, 사용이 매우 편리합니다.

실제로도, `basic_string_view` 는 보통 두 개의 멤버만 가지는데, 하나는 시작점을 가리키는 포인터(`CharT*`) 와 가리키는 대상의 크기 입니다.

이름에서도 알 수 있듯이 `string` 을 **볼 수 만** 있기 때문에 가리키고 있는 문자열을 수정할 수 는 없습니다. 또한 주의할 점으로 **가리키고 있는 문자열이 메모리에서 소멸되지 않도록** 해야만 합니다.

```cpp-formatted
std::string_view good("a string literal");  // OK. static 배열을 가리키고 있음

const char* func() {
  string s = "abc";
  return s.c_str();
}
std::string_view bad(func());  // BAD. 이미 소멸된 string 을 가리킴
```

`basic_string_view` 는 `<string_view>` 헤더파일에 정의되어 있습니다.

|타입|정의|
|----|----|
|`std::string_view`|`std::basic_string_view<char>`|
|`std::wstring_view`|`std::basic_string_view<wchar_t>`|
|`std::u16string_view`|`std::basic_string_view<char16_t>`|
|`std::u32string_view`|`std::basic_string_view<char32_t>`|

### 템플릿 인자들

* `CharT`	-	문자 타입
* `Traits`	-	`CharTraits` 클래스로, 문자들 간의 연산을 정의한다. `basic_string` 의 경우와 같이, `Traits::char_type` 이 `CharT` 와 반드시 일치해야만 한다.

### 멤버 타입들


|멤버 타입|정의|
|-------|---|
|`traits_type`|`Traits` (템플릿 인자)|
|`value_type`|`CharT` (템플릿 인자)|
|`pointer`|`CharT*`|
|`const_pointer`|`const CharT*`|
|`reference`|`CharT&`|
|`const_reference`|`const CharT&`|
|`const_iterator`|`CharT` 를 값으로 가지는 반복자 `RandomAccessIterator, ConstexprIterator, ContiguousIterator`|
|`iterator`|`const_iterator`|
|`reverse_iterator`|`const_reverse_iterator`|
|`const_reverse_iterator`|`std::reverse_iterator<const_iterator>`|
|`size_type`|`std::size_t`|
|`difference_type`|`std::ptrdiff_t`|

`string_view` 의 경우 문자열을 수정할 수 없기 때문에, `iterator` 와 `const_iterator` 모두 같은 상수 반복자 타입입니다.

### 멤버 함수들

* [생성자](/242)
* `operator=` : 가리킬 문자열을 지정한다.

### 반복자 관련

* `begin, cbegin` : 시작점을 가리키는 반복자를 리턴한다.
* `end, cend` : 끝 점을 가리키는 반복자를 리턴한다.
* `rbegin, crbegin` : 시작점을 가리키는 역반복자를 리턴한다. (즉 실제로 문자열 맨 마지막 문자를 가리키고 있음
* `rend, crend`: 끝 점을 가리키는 역반복자를 리턴한다.

참고로 `string` 과는 달리 `string_view` 의 경우 c 의 유무와 관계 없이 모두 상수 반복자 이다.

### 원소 접근 관련

* `operator[]` : 특정 위치의 문자에 접근한다. (참고로 `string` 과는 달리 `operator[]` 가 상수 레퍼런스를 리턴한다.)
* `at` : 특정 위치의 문자에 접근한다 (이 때, **범위를 체크함**)
* `front` : 첫 번째 문자에 접근한다.
* `back` : 마지막 문자에 접근한다.
* `data` : 문자열의 첫 번째 문자를 가리키는 포인터를 리턴한다.

### 문자열 크기 관련

* `size, length` : 가리키는 문자열의 길이를 리턴한다.
* `max_size` : 문자열의 최대 길이를 리턴한다.
* `empty` : 가리키는 문자열이 비어있는지 확인한다.

### 문자열 관련 작업

아래 설명할 문자열 관련 작업들은 문자열을 직접적으로 수정하지 않는다.

* `remove_prefix` : 시작 포인터를 뒤쪽으로 옮긴다. (이를 통해 마치 접두사를 없애는 듯한 효과를 낼 수 있다)
* `remove_suffix` : 보는 크기를 줄인다 (이를 통해 접미사를 없앤 듯한 효과를 낼 수 있다)
* `swap` : 가리키는 문자열을 바꾼다.
* `copy` : 문자들을 복사한다.
* `substr` : 부분 문자열을 리턴한다.
* `compare` : 두 `view` 들을 비교한다.
* `starts_with : string_view` 가 인자로 전달된 접두사로 시작하는지 확인한다.
* `ends_with: string_view` 가 인자로 전달된 접미사로 끝나는지 확인한다.

#### 문자열 검색 관련

* `find` : 문자열을 검색한다.
* `rfind` : 문자열을 뒤에서 부터 검색한다.
* `find_first_of` : 가장 처음으로 전달된 문자열에 있는 문자가 나타나는 위치를 찾는다.
* `find_first_not_of` : 가장 처음으로 전달된 문자열에 없는 문자가 나타나는 위치를 찾는다.
* `find_last_of` : 가장 마지막으로 전달된 문자열에 있는 문자가 나타나는 위치를 찾는다.
* `find_last_not_of` : 가장 처음으로 전달된 문자열에 없는 문자가 나타나는 위치를 찾는다.

#### 상수

`npos` : 사용 예에 따라 의미가 달라짐.